/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public final class ItemTagCondition
implements Condition<ItemStack> {
    private final HolderSet.Named<Item> entries;

    private ItemTagCondition(HolderSet.Named<Item> entries) {
        this.entries = entries;
    }

    public static ConditionFactory<ItemStack> factory() {
        return ConditionFactory.withData(ItemTagCondition::parse);
    }

    public static Result<ItemTagCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ItemTagCondition::parse);
    }

    public static Result<ItemTagCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optTag = rootObject.get("tag").andThen(JsonParseUtils::parseItemTag).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ItemTagCondition((HolderSet.Named<Item>)((HolderSet.Named)optTag.orElseThrow())));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.entries.m_203333_(itemStack.m_220173_());
    }
}

